%define name open-iscsi-devel
%define version 2.0
%define release 8425165dfed27945e8509c141cea245d1739e372

Summary		: open-iscsi header files.
Name		: %{name}
Version		: %{version}
Release		: %{release}
Vendor		: Voltaire Inc.
Source		: open-iscsi-devel-%{version}.tar.gz
Packager	: Erez Zilber <erezz@voltaire.com>
Provides	: open-iscsi-devel
Group		: Storage 
License		: GPL
BuildRoot:      %{_tmppath}/%{name}


%description
This package provides open-iscsi header files

%define kversion $(uname -r)
%define kernel_src /lib/modules/`uname -r`/source

%prep

rm -rf $RPM_BUILD_ROOT

%setup

%build

%install

mkdir -p ${RPM_BUILD_ROOT}%{kernel_src}/include/scsi/

cp $PWD/include/scsi/iscsi_if.h ${RPM_BUILD_ROOT}%{kernel_src}/include/scsi/
cp $PWD/include/scsi/iscsi_proto.h ${RPM_BUILD_ROOT}%{kernel_src}/include/scsi/
cp $PWD/include/scsi/scsi_transport_iscsi.h ${RPM_BUILD_ROOT}%{kernel_src}/include/scsi/
cp $PWD/include/scsi/libiscsi.h ${RPM_BUILD_ROOT}%{kernel_src}/include/scsi/

# build the file list
FILE_LIST=%{_tmppath}/open-iscsi-h-file-list

find ${RPM_BUILD_ROOT} -type f| sed "s|${RPM_BUILD_ROOT}||" > ${FILE_LIST}
cat ${FILE_LIST}

%clean
[ "${RPM_BUILD_ROOT}" != "/" -a -d ${RPM_BUILD_ROOT} ] && rm -rf ${RPM_BUILD_ROOT}

%pre

echo "Checking if the kernel source is installed"

%if "%{_vendor}" == "suse"
	if ! ( $(rpm -q kernel-source  > /dev/null 2>&1) ) ; then
		echo "Cannot install. Please install the kernel-source rpm first"
		exit 1
	fi
%else
%if "%{_vendor}" == "redhat"
	if ! ( $(rpm -q kernel-devel  > /dev/null 2>&1) ) ; then
		echo "Cannot install. Please install the kernel-devel rpm first"
		exit 1
	fi
%endif
%endif

case $(uname -r | sed "s/-ppc64\|-smp//") in
        2.6.16.21-0.8)
		echo "Backup open-iscsi h files in the kernel tree"
		mv %{kernel_src}/include/scsi/iscsi_if.h %{kernel_src}/include/scsi/iscsi_if.h.saved
                mv %{kernel_src}/include/scsi/iscsi_proto.h %{kernel_src}/include/scsi/iscsi_proto.h.saved
                mv %{kernel_src}/include/scsi/scsi_transport_iscsi.h %{kernel_src}/include/scsi/scsi_transport_iscsi.h.saved
                
                ;; 
        *)
                echo "%{kversion} kernel is not supported"
                exit 1
                ;;
esac

%post

%postun

echo "Restoring the old open-iscsi h files"
mv %{kernel_src}/include/scsi/iscsi_if.h.saved %{kernel_src}/include/scsi/iscsi_if.h
mv %{kernel_src}/include/scsi/iscsi_proto.h.saved %{kernel_src}/include/scsi/iscsi_proto.h
mv %{kernel_src}/include/scsi/scsi_transport_iscsi.h.saved %{kernel_src}/include/scsi/scsi_transport_iscsi.h

%files -f %{_tmppath}/open-iscsi-h-file-list

